/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.config.ui.entries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.createmod.catnip.config.ui.ConfigAnnotations;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.config.ui.ConfigScreen;
import net.createmod.catnip.config.ui.ConfigScreenList;
import net.createmod.catnip.config.ui.SubMenuConfigScreen;
import net.createmod.catnip.data.Pair;
import net.createmod.catnip.gui.element.DelegatedStencilElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3674;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ValueEntry<T>
extends ConfigScreenList.LabeledEntry {
    protected static final int resetWidth = 28;
    public static final class_3674 clipboardHelper = new class_3674();
    protected ForgeConfigSpec.ConfigValue<T> value;
    protected ForgeConfigSpec.ValueSpec spec;
    protected BoxWidget resetButton;
    protected boolean editable = true;

    public ValueEntry(String label, ForgeConfigSpec.ConfigValue<T> value, ForgeConfigSpec.ValueSpec spec) {
        super(label);
        this.value = value;
        this.spec = spec;
        this.path = String.join((CharSequence)".", value.getPath());
        this.resetButton = (BoxWidget)((AbstractSimiWidget)new BoxWidget(0, 0, 16, 16).showingElement(PonderGuiTextures.ICON_CONFIG_RESET.asStencil())).withCallback(() -> {
            this.setValue(spec.getDefault());
            this.onReset();
        });
        this.resetButton.modifyElement(e -> ((DelegatedStencilElement)e).withElementRenderer(BoxWidget.gradientFactory.apply(this.resetButton)));
        this.listeners.add(this.resetButton);
        List path = value.getPath();
        this.labelTooltip.add(class_2561.method_43470((String)label).method_27692(class_124.field_1068));
        String comment = spec.getComment();
        if (comment == null || comment.isEmpty()) {
            return;
        }
        ArrayList<String> commentLines = new ArrayList<String>(Arrays.asList(comment.split("\n")));
        Pair<String, Map<String, String>> metadata = ConfigHelper.readMetadataFromComment(commentLines);
        if (metadata.getFirst() != null) {
            this.unit = metadata.getFirst();
        }
        if (metadata.getSecond() != null && !metadata.getSecond().isEmpty()) {
            this.annotations.putAll(metadata.getSecond());
        }
        this.labelTooltip.addAll(commentLines.stream().filter(s -> !s.startsWith("Range")).map(s -> s.equals(".") ? " " : s).map(str -> class_2561.method_43470((String)str)).flatMap(stc -> FontHelper.cutTextComponent((class_2561)stc, FontHelper.Palette.ALL_GRAY).stream()).toList());
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRelog.TRUE.getName())) {
            this.labelTooltip.addAll(FontHelper.cutTextComponent((class_2561)class_2561.method_43471((String)"catnip.ui.value_entry.relog_required"), FontHelper.Palette.GRAY_AND_GOLD));
        }
        if (this.annotations.containsKey(ConfigAnnotations.RequiresRestart.CLIENT.getName())) {
            this.labelTooltip.addAll(FontHelper.cutTextComponent((class_2561)class_2561.method_43471((String)"catnip.ui.value_entry.restart_required"), FontHelper.Palette.GRAY_AND_RED));
        }
        this.labelTooltip.add(class_2561.method_43470((String)(ConfigScreen.modID + ":" + (String)path.get(path.size() - 1))).method_27692(class_124.field_1063));
    }

    @Override
    protected void setEditable(boolean b) {
        this.editable = b;
        this.resetButton.field_22763 = this.editable && !this.isCurrentValueDefault();
        this.resetButton.animateGradientFromState();
    }

    @Override
    public void tick() {
        super.tick();
        this.resetButton.tick();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button != 0) {
            return false;
        }
        long handle = class_310.method_1551().method_22683().method_4490();
        if (!class_3675.method_15987((long)handle, (int)341)) {
            return false;
        }
        ModConfig.Type configType = ModConfig.Type.CLIENT;
        class_437 screen = class_310.method_1551().field_1755;
        if (screen instanceof SubMenuConfigScreen) {
            SubMenuConfigScreen subMenuScreen = (SubMenuConfigScreen)screen;
            configType = subMenuScreen.type;
        }
        this.annotations.put("highlight", ":)");
        clipboardHelper.method_15979(handle, ConfigScreen.modID + ":" + configType.extension() + "." + this.path);
        return true;
    }

    @Override
    public void method_25343(class_332 graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.method_25343(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        this.resetButton.method_46421(x + width - 28 + 6);
        this.resetButton.method_46421(y + 10);
        this.resetButton.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getLabelWidth(int totalWidth) {
        return (int)((float)totalWidth * 0.4f) + 30;
    }

    public void setValue(@Nonnull T value) {
        ConfigHelper.setValue(this.path, this.value, value, this.annotations);
        this.onValueChange(value);
    }

    @Nonnull
    public T getValue() {
        return ConfigHelper.getValue(this.path, this.value);
    }

    protected boolean isCurrentValueDefault() {
        return this.spec.getDefault().equals(this.getValue());
    }

    public void onReset() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange(T newValue) {
        this.resetButton.field_22763 = this.editable && !this.isCurrentValueDefault();
        this.resetButton.animateGradientFromState();
    }

    protected void bumpCog() {
        this.bumpCog(10.0f);
    }

    protected void bumpCog(float force) {
        ConfigScreen.cogSpin.bump(3, force);
    }
}

